% ------------------------------------------------------------------------
% Script: infile_1d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 1D P-N model
% ------------------------------------------------------------------------

    % % System name
 
    system='1D P-N model';
 
    % % The absolute path to save the result files
 
    filepath=pwd;
 
    % % The dimension of P-N model: 1 or 2
 
    misdim=1;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
    
    % % The data of GSFE (unit: J/m2) and normalized disregistry vector (unit:1)
    
    Ux=[0
0.05146
0.10016
0.14829
0.19832
0.2514
0.29877
0.34937
0.39998
0.44982
0.501
0.55046
0.59783
0.64958
0.69904
0.74831
0.79758
0.84876
0.89746
0.94616
1];
    SFE=[0
0.04881
0.17007
0.33558
0.51348
0.6905
0.8268
0.93478
0.987
1.01533
1.01267
1.01533
0.99497
0.93478
0.82946
0.69581
0.52145
0.33558
0.17007
0.04881
-0.01226];
    
    % % Which trial function of disregistry vector to employ (>=1)
    
    Nmis=6;
       
    % % Considering the first-order approximation in the trial function of disregistry
    %   vector (1) or NOT (0)
    
    mis_1st=0;
    
    % % The value of Burgers Vector (unit: A)
 
    BurVect=5.571; 
    
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=109.25;
    poisson_ratio=0.2417;
    
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='s';
    
    % % Which GSFE fitting function to employ (>=0)
    
    fitcut=3;
    
    % % Matrix of the lower and upper bounds, and initial values of each unknown 
    %   variable ([Lower bound, Upper bound, StartPoint]) 
    
    Xcoef_range=[  0.0000,  1.0000,  0.1667];
    Xdist_range=[-20.0000, 20.0000,  10.0000];
    Xwid_range =[  0.0000, 10.0000,  2.0000];
    Xalpha_range=[ 0.0000,  2.00000, 1.0000];
    
    % % The mothed for fitting the restoring force: "1d_fitting_toolbox" or "1d_lsq_curvefit"
    
    fitmethod='1d_lsq_curvefit';
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
 
    % % Interplanar distance ?x (unit: A) 

    % Inpas=5.571;
    Inpas=3.939;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
